#version 140
#extension GL_EXT_gpu_shader4 : enable
//Pertubated JuliaMod01.fsh by Spongman
//https://www.shadertoy.com/view/3d2yzw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.666  //0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float MAX = 200.;
const vec2 P = vec2(0.001, 0.0);

vec2 mul(vec2 z, vec2 w) { return vec2 (z.x*w.x - z.y*w.y, z.x*w.y + z.y*w.x); }

vec3 pal( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d )
{
    return a + b*cos( 6.28318*(c*t+d) );
}

float J(vec2 z, vec2 c, vec2 p)
{
    float i;
    for(i = MAX; i --> 0.;)
    {
        float lz = dot(z, z);
        if (lz > 4.0) {
            return (i + log2(log2(lz))) / MAX;
        }

        vec2 z2 = vec2(z.x*z.x - z.y*z.y, 2. * z.x * z.y);
        vec2 rz2 = vec2(z2.x, -z2.y) / dot(z2, z2);
        
        z = z2 + c - mul(p, rz2);
    }
    
    return 1.0;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
    uv *= 2.;
    
    vec2 m = iMouse.xy*vec2(1.,.5)/iResolution.xy - vec2(0.5,0.);
    
    vec2 c = vec2(-1.0, 0.0) / 100.0;

    // Time varying pixel color
    float val = J(uv, c, m /2.);
    val = pow(val,10.);
    vec3 col =  pal( val * 1.5, vec3(0.5,0.5,0.5),vec3(0.5,0.5,0.5),vec3(1.0,1.0,1.0),vec3(0.0,0.10,0.20) );

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}




